/**
(c) 2020 Contecon Software GmbH Author E. Schreiner
**/

import de.contecon.picapport.groovy.IAddonContext;
import de.contecon.picapport.groovy.PathFilter;


class PrivateFileFilter extends PathFilter {
 
  public Map init(IAddonContext addonContext) {
            
	addonContext.getLogger().logMessage(" Simple Addon-Filter for private Files loaded. Autor: E. Schreiner (c)2020 Contecon Software GmbH" );
	addonContext.getLogger().logMessage(" AddonPath="+ addonContext.getAddonPath());
	return [version:'1.0.0']; // return Map with version member 
	}

  public void beforeDirectoryScan(IAddonContext addonContext, File directory)  {
      /* remove this comment Line to e.G. dynamically load photos to some specific directories 
      addonContext.getLogger().logDebugMessage("beforeDirectoryScan: $directory");
	  remove this comment Line to dynamically load photos to some specific directories */
    }	
	
	
  public boolean shouldAddDirectory(IAddonContext addonContext, File directory) {
    boolean accepted=true;
	
	/* remove this comment Line to enable the directory Filter 
	String dirname=directory.getAbsolutePath().toLowerCase();
  
    if(  dirname.contains("privat")
       ||dirname.contains("private")
       ||dirname.contains("secret")
       ) {
       accepted=false;  
       }
    if(!accepted) {
      addonContext.getLogger().logDebugMessage("shouldAddDirectory did not accept $dirname");
      }
	remove this comment Line to enable the directory Filter */
    return accepted;
    }
  
  public boolean shouldAddFile(IAddonContext addonContext, File file) {
    boolean accepted=true;
	
	/* remove this comment Line to enable the directory Filter 
	String filename=file.getAbsolutePath().toLowerCase();
	
    if(  filename.contains("privat")
       ||filename.contains("private")
       ||filename.contains("secret")
       ) {
       accepted=false;  
       }
    if(!accepted) {
      addonContext.getLogger().logDebugMessage("shouldAddFile did not accept $filename");
      }	
	remove this comment Line to enable the directory Filter */
    return accepted;
    }

}	