/**
(c) 2020 Contecon Software GmbH Author E. Schreiner

set a red title for Thumbnails if original file is not a jpeg. 
requires userOption:
  paSetOption: thumbs.title=fromaddon
  
**/

import de.contecon.imageutils.IccImageMetaData;

import de.contecon.picapport.IPhotoMetaDataFilter;
import de.contecon.picapport.groovy.IAddonContext;
import de.contecon.picapport.groovy.PhotoFieldProvider;

class NonJpgTitleField extends PhotoFieldProvider {
  
public Map init(IAddonContext addonContext) {
	addonContext.getLogger().logMessage(" Addon loaded Autor: E. Schreiner (c)2020 Contecon Software GmbH" );
	[version:'1.0.0']; //return Map with version. 						
	}
 
public void setFieldValues(IAddonContext addonContext, IccImageMetaData metaDataFile, IPhotoMetaDataFilter metadataDatabase) {
   def oExt=metadataDatabase.getPhotoInFileSystem().getOriginalFileExtension();
   if(null != oExt && oExt.length() > 1) {
     oExt= oExt.substring(1).toUpperCase();
     if(!(oExt == "JPG" || oExt =="JPEG")) {
       metadataDatabase.setThumbTitle(oExt);
       metadataDatabase.setThumbTitleColor("#DD130E");
       }    
     } 
   }       
}
