/**
(c) 2020 Contecon Software GmbH Author E. Schreiner

This is a simple tool for demonstrating and testing of
PicApports Groovy procedures functions

**/

import de.contecon.picapport.IPhotoMetaData;
import de.contecon.picapport.groovy.IAddonContext;
import de.contecon.picapport.groovy.IAddonExecutionContext;
import de.contecon.picapport.groovy.IAddonFileToProcess;
import de.contecon.picapport.groovy.PhotoFileProcessor;

class GroovyProceduresTestTool extends PhotoFileProcessor {

public Map init(IAddonContext addonContext) {
	addonContext.getLogger().logMessage(" Addon loaded. Autor: E. Schreiner (c)2020 Contecon Software GmbH" );
    
	def meta =  [
                version:'1.0.0',
				functions: [
						   f1: [
							   name:       'PicApport Groovy Test Tool',
							   desc:       'Test and demonstrate Groovy procedures',
							   
                               parameter: [
										  generateReportHeader: [
											  type:   'checkbox',
											  label:  'Generate report header',
											  value:  true, 										   
											  ],
										  generateReportDetails: [
											  type:   'checkbox',
											  label:  'Generate report details',
											  value:  true, 										   
											  ],
                                          generateReportFooter: [
											  type:   'checkbox',
											  label:  'Generate report footer',
											  value:  true, 										   
											  ],											  
									      setShowResults: [
											  type:   'checkbox',
											  label:  'showResults',
											  value:  true, 										   
											  ],
                                          generateHeaderException: [
											  type:   'checkbox',
											  label:  'Generate exception during header processing',
                                              value: false
											  ],											  
                                          generateFooterException: [
											  type:   'checkbox',
											  label:  'Generate exception during footer processing',
                                              value: false
											  ],											  
                                          generateDetailsException: [
                                            type: 'range',
                                            label: 'Generate Exception each Nth selected item' ,
                                            value: '0',
                                            min:   '0',
                                            max:   '10',
                                            ],
									      ]
                               ]							   
						   ]

				]
	}
 
/**
 * This method is called one time befor processing of each photo starts
 * use IAddonExecutionContext aec as a map to store values over the livetime of this procedure 
 */
public void start(IAddonContext addonContext, IAddonExecutionContext aec) {
    addonContext.getLogger().logMessage(" Addon loaded. Autor: E. Schreiner (c)2020 Contecon Software GmbH" );
	
    aec.setShowResults(aec.setShowResults);     // Indicate that this procedure shows a result to the user
	aec.currentPhoto=0;

    if(aec.generateReportHeader) {
	  aec.getPhotoFileProcessorResultGenerator().addGroupData("PicApport GroovyProceduresTestTool Header-Map", ["Header map entry":"Header generation requested"]);
      } 	
    if(aec.generateHeaderException) {
	  throw new RuntimeException("This is an Exception during start() processing.");
	  }
    }
  
    
/**
 * This method is called for each selected photo
 */
public void processPhotoFile(IAddonContext addonContext, IAddonExecutionContext aec, IAddonFileToProcess fileToProcess) {
    aec.currentPhoto++;
	
    def originalFile = fileToProcess.getOriginalFile();
    def baseAttrMap=[:] as LinkedHashMap; // Content og this map will always be visible below the image (Filename etc)
        baseAttrMap['Name']         = originalFile.getName();
        baseAttrMap['Path']         = originalFile.getParent();
        baseAttrMap['Length']       = originalFile.length();
        baseAttrMap['Last Modified']= new Date(originalFile.lastModified());
	
    // The logger logs to the configured PicApport Logfile    	
    addonContext.getLogger().logMessage(" process ${aec.currentPhoto}. PhotoFile: ${originalFile.getCanonicalPath()}" );
	
    if(aec.generateReportDetails) {
	  aec.getPhotoFileProcessorResultGenerator().addGroupData("PicApport exiftool Addon", baseAttrMap);
      } 	
      
    if((aec.generateDetailsException as Integer) > 0) {
	  if(aec.currentPhoto.mod(aec.generateDetailsException as Integer) == 0) {
   	    throw new RuntimeException("This is an Exception during processing of ${aec.currentPhoto}. file.");
		}
	  }
    }
	
/**
  This method is called one time before processing will be terminated
 */
public void stop(IAddonContext addonContext, IAddonExecutionContext aec) {
    addonContext.getLogger().logMessage(" stop has been called." );
  
    if(aec.generateReportFooter) {
	  aec.getPhotoFileProcessorResultGenerator().addGroupData("PicApport GroovyProceduresTestTool Footer-Map", ["Files processed":aec.currentPhoto]);
      } 	
    if(aec.generateFooterException) {
	  throw new RuntimeException("This is an Exception during stop() processing.");
	  }
    }	
    		
}
